define([
    'underscore',
    'modules/page/popup/popup-view',
    'text!modules/new-appointment-request/views/direct/pac-team/modal.html',
],
function (_, PopupView, template) {
    'use strict';

    return PopupView.extend({
        id: 'pact-team',
        template: template,

        templateContext: function() {
            return {
                primaryProviderList: this.options.primaryProviderList,
                teamList: this.getTeamList(),
            };
        },

        getTeamList: function() {
            var teams = this.options.team.where({possiblePrimary: ''});
            var staff = _.map(teams, function(model) {
                return model.get('staffName');
            });

            return staff.join('; ');
        },
    });
});
